-- PulseWatch Database Schema
-- Uptime Monitoring Dashboard

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

-- --------------------------------------------------------
-- Table: pw_users (Admin users)
-- --------------------------------------------------------

CREATE TABLE `pw_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role` enum('admin','viewer') DEFAULT 'viewer',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Default admin user (password: admin123 - CHANGE THIS!)
INSERT INTO `pw_users` (`username`, `email`, `password`, `role`) VALUES
('admin', 'admin@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin');

-- --------------------------------------------------------
-- Table: pw_services (Services to monitor)
-- --------------------------------------------------------

CREATE TABLE `pw_services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `url` varchar(500) NOT NULL,
  `type` enum('http','https','ping','port','keyword') DEFAULT 'https',
  `check_interval` int(11) DEFAULT 300 COMMENT 'Interval in seconds',
  `timeout` int(11) DEFAULT 30 COMMENT 'Timeout in seconds',
  `port` int(11) DEFAULT NULL COMMENT 'For port checks',
  `keyword` varchar(255) DEFAULT NULL COMMENT 'For keyword checks',
  `keyword_type` enum('exists','not_exists') DEFAULT 'exists',
  `expected_status` int(11) DEFAULT 200,
  `headers` text DEFAULT NULL COMMENT 'JSON headers for requests',
  `status` enum('up','down','paused','pending') DEFAULT 'pending',
  `last_check` timestamp NULL DEFAULT NULL,
  `last_response_time` int(11) DEFAULT NULL COMMENT 'Response time in ms',
  `uptime_percentage` decimal(5,2) DEFAULT 100.00,
  `is_active` tinyint(1) DEFAULT 1,
  `notify_email` varchar(255) DEFAULT NULL,
  `notify_on_down` tinyint(1) DEFAULT 1,
  `notify_on_up` tinyint(1) DEFAULT 1,
  `consecutive_fails` int(11) DEFAULT 0,
  `fail_threshold` int(11) DEFAULT 3 COMMENT 'Consecutive fails before alert',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_by` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `is_active` (`is_active`),
  KEY `created_by` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- Table: pw_checks (Check history)
-- --------------------------------------------------------

CREATE TABLE `pw_checks` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `service_id` int(11) NOT NULL,
  `status` enum('up','down') NOT NULL,
  `response_time` int(11) DEFAULT NULL COMMENT 'Response time in ms',
  `status_code` int(11) DEFAULT NULL,
  `error_message` text DEFAULT NULL,
  `checked_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `service_id` (`service_id`),
  KEY `checked_at` (`checked_at`),
  KEY `service_status` (`service_id`, `status`, `checked_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- Table: pw_incidents (Downtime incidents)
-- --------------------------------------------------------

CREATE TABLE `pw_incidents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service_id` int(11) NOT NULL,
  `started_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ended_at` timestamp NULL DEFAULT NULL,
  `duration` int(11) DEFAULT NULL COMMENT 'Duration in seconds',
  `error_message` text DEFAULT NULL,
  `is_resolved` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `service_id` (`service_id`),
  KEY `is_resolved` (`is_resolved`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- Table: pw_notifications (Notification log)
-- --------------------------------------------------------

CREATE TABLE `pw_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service_id` int(11) NOT NULL,
  `type` enum('down','up','degraded') NOT NULL,
  `message` text NOT NULL,
  `sent_to` varchar(255) NOT NULL,
  `sent_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('sent','failed') DEFAULT 'sent',
  PRIMARY KEY (`id`),
  KEY `service_id` (`service_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------
-- Table: pw_settings (Application settings)
-- --------------------------------------------------------

CREATE TABLE `pw_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `setting_type` enum('string','int','bool','json') DEFAULT 'string',
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting_key` (`setting_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Default settings
INSERT INTO `pw_settings` (`setting_key`, `setting_value`, `setting_type`, `description`) VALUES
('site_name', 'PulseWatch', 'string', 'Application name'),
('admin_email', 'admin@example.com', 'string', 'Admin notification email'),
('smtp_host', '', 'string', 'SMTP server host'),
('smtp_port', '587', 'int', 'SMTP server port'),
('smtp_user', '', 'string', 'SMTP username'),
('smtp_pass', '', 'string', 'SMTP password'),
('smtp_from', '', 'string', 'From email address'),
('smtp_from_name', 'PulseWatch', 'string', 'From name'),
('check_enabled', '1', 'bool', 'Enable monitoring checks'),
('public_dashboard', '1', 'bool', 'Allow public access to dashboard'),
('retention_days', '90', 'int', 'Days to keep check history'),
('timezone', 'UTC', 'string', 'Application timezone');

-- --------------------------------------------------------
-- Foreign Keys
-- --------------------------------------------------------

ALTER TABLE `pw_services`
  ADD CONSTRAINT `fk_services_user` FOREIGN KEY (`created_by`) REFERENCES `pw_users` (`id`) ON DELETE SET NULL;

ALTER TABLE `pw_checks`
  ADD CONSTRAINT `fk_checks_service` FOREIGN KEY (`service_id`) REFERENCES `pw_services` (`id`) ON DELETE CASCADE;

ALTER TABLE `pw_incidents`
  ADD CONSTRAINT `fk_incidents_service` FOREIGN KEY (`service_id`) REFERENCES `pw_services` (`id`) ON DELETE CASCADE;

ALTER TABLE `pw_notifications`
  ADD CONSTRAINT `fk_notifications_service` FOREIGN KEY (`service_id`) REFERENCES `pw_services` (`id`) ON DELETE CASCADE;

-- --------------------------------------------------------
-- Indexes for performance
-- --------------------------------------------------------

CREATE INDEX `idx_checks_service_time` ON `pw_checks` (`service_id`, `checked_at` DESC);
CREATE INDEX `idx_incidents_service_resolved` ON `pw_incidents` (`service_id`, `is_resolved`, `started_at` DESC);
