<?php
/**
 * PulseWatch Configuration
 * Uptime Monitoring Dashboard
 */

// Error reporting (disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

// Timezone
date_default_timezone_set('UTC');

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'pulsewatch');
define('DB_USER', 'your_db_user');
define('DB_PASS', 'your_db_password');
define('DB_CHARSET', 'utf8mb4');

// Application Configuration
define('APP_NAME', 'PulseWatch');
define('APP_URL', 'https://your-domain.com/pulsewatch');
define('APP_VERSION', '1.0.0');

// Security
define('SECRET_KEY', 'change-this-to-a-random-string-at-least-32-chars');
define('SESSION_LIFETIME', 86400); // 24 hours
define('CSRF_TOKEN_LIFETIME', 3600); // 1 hour

// API Configuration
define('API_RATE_LIMIT', 100); // requests per minute
define('API_TOKEN_LIFETIME', 2592000); // 30 days

// Monitoring Configuration
define('DEFAULT_CHECK_INTERVAL', 300); // 5 minutes
define('DEFAULT_TIMEOUT', 30); // 30 seconds
define('MAX_CONCURRENT_CHECKS', 10);
define('FAIL_THRESHOLD', 3); // consecutive fails before alert

// Paths
define('ROOT_PATH', dirname(__DIR__));
define('INCLUDES_PATH', ROOT_PATH . '/includes');
define('LOGS_PATH', ROOT_PATH . '/logs');

// CORS Settings (adjust for production)
define('CORS_ORIGIN', '*');

// Session configuration
session_name('pulsewatch_session');
session_start();
